const StorageBuilder = (storage: Storage) => ({
  setItem: (key: string, value: string) => storage.setItem(key, value),
  getItem: (key: string) => storage.getItem(key),
  removeItem: (key: string) => storage.removeItem(key),
});

const STORAGE_BASE_NAME = 'hw-ars';

// session
export const STORAGE_SESSION_ACT = `${STORAGE_BASE_NAME}_act`;

export const storageService = {
  local: StorageBuilder(window.localStorage),
  session: StorageBuilder(window.sessionStorage),
};
