// base
import React from 'react';
import { Result, Button } from 'antd';
import { useNavigate } from 'react-router';
import { ROUTE_ROOT } from 'routes/const';

export const NotFoundResult = () => {
  const navigate = useNavigate();

  return (
    <Result
      status="404"
      title="404"
      subTitle="Sorry, the page you visited does not exist."
      extra={
        <Button
          className="btn-36 btn-primary color-white"
          type="primary"
          onClick={() => navigate(ROUTE_ROOT)}
        >
          Back Home
        </Button>
      }
    />
  );
};
