// base
import React from 'react';
import { Result, Button } from 'antd';
import { useNavigate } from 'react-router';
import { ROUTE_ROOT } from 'routes/const';

export const AuthorizedResult = () => {
  const navigate = useNavigate();

  return (
    <Result
      status="403"
      title="403"
      subTitle="Sorry, you are not authorized to access this page."
      extra={
        <Button
          className="btn-36 btn-primary color-white"
          type="primary"
          onClick={() => navigate(ROUTE_ROOT)}
        >
          Back Home
        </Button>
      }
    />
  );
};
