import styled from 'styled-components';
import { Button } from 'antd';

export const ModalWrap = styled.div`
  .ant-modal-title {
    font-size: 22px;
  }

  .ant-modal-close {
    right: -56px;
    background: rgba(0, 0, 0, 0.2);
    color: #fff;
  }

  .deleteBtn {
    position: absolute;
    top: 75px;
    right: 25px;
    width: 140px;
    height: 40px;
    border: 1px solid #f00;
    color: #f00;
  }

  .ant-descriptions-view {
    overflow: visible;
  }

  .file-name {
    margin: 0 0 0 20px;
    color: rgba(0, 0, 0, 0.5);
  }

  .upload-box {
    display: flex;
    align-items: center;
  }

  .upload > div > .ant-form-item-control-input {
    display: none;
  }
`;

export const ConfirmBtn = styled(Button)`
  display: block;
  margin: 46px auto 0;
  width: 180px;
  height: 48px;
`;

export const UploadBtn = styled(Button)`
  width: 140px;
  height: 35px;
  color: #043b72;
  border-color: #043b72;

  :hover,
  :active,
  :focus {
    color: #043b72;
    border-color: #043b72;
  }
`;

export const TableWrap = styled.div`
  height: 500px;
  overflow: scroll;
  overflow-x: hidden;
  background-color: #fff;
  padding: 25px 30px 15px;
  margin: 10px 0;
  border: 1px solid rgba(0, 0, 0, 0.1);

  .ant-table {
    border: 1px solid rgba(0, 0, 0, 0.03);
  }

  .ant-table-thead > tr > th,
  .ant-table-tbody > tr > td {
    text-align: center;
    letter-spacing: -0.5px;
    padding: 10px;
  }

  .thumbnail {
    width: 150px;
  }
`;
