import AxiosInstanceCreator from 'services/api';
import { LoopbackFilter, LoopbackWhere } from 'services/loopback';
import { ResponseVideo } from 'types/video';

export const videoInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_API_URL}/api/v1/video`,
  withCredentials: true,
}).create();

export const videoAPI = {
  list: (filter: LoopbackFilter): Promise<ResponseVideo[]> => {
    return videoInstance
      .get('', {
        params: { filter },
      })
      .then((res) => res.data);
  },
  count: (where: LoopbackWhere): Promise<{ count: number }> => {
    return videoInstance.get('/count', { params: { where } }).then((res) => res.data);
  },
  create: (data: ResponseVideo) => {
    return videoInstance.post('', data).then((res) => res.data);
  },
  update: (id: string, data: ResponseVideo): Promise<ResponseVideo[]> => {
    return videoInstance.patch(`/${id}`, data).then((res) => res.data);
  },
};
