import AxiosInstanceCreator from 'services/api';
import { UsersDataUploadData } from 'types/usersData';

export const usersDataInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_API_URL}/api/v1/usersData`,
  withCredentials: true,
}).create();

export const usersDataAPI = {
  uploadFile: (file: any): Promise<UsersDataUploadData> => {
    const formData = new FormData();
    formData.append('file', file);
    return usersDataInstance.post(`/uploadFile`, formData).then((res) => res.data);
  },
  deleteAll: (): Promise<{ count: number }> => {
    return usersDataInstance.post('/deleteAllData').then((res) => res.data);
  },
};
