import AxiosInstanceCreator from 'services/api';
import { LoopbackFilter, LoopbackWhere } from 'services/loopback';
import { MenuResult } from 'types/statistics';

export const statisticsInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_API_URL}/api/v1/statistics`,
  withCredentials: true,
}).create();

export const statisticsAPI = {
  action: (filter: LoopbackFilter, group: string): Promise<MenuResult[]> => {
    return statisticsInstance.get('/action', { params: { filter, group } }).then((res) => res.data);
  },
  detail: (filter: LoopbackFilter): Promise<any> => {
    return statisticsInstance.get('/', { params: { filter } }).then((res) => res.data);
  },
  detailCount: (where: LoopbackWhere): Promise<any> => {
    return statisticsInstance.get('/count', { params: { where } }).then((res) => res.data.count);
  },
  select: (filter: any): any => {
    return statisticsInstance.get('/select', { params: filter }).then((res) => res.data);
  },
};
