import { ResponseCdnurls } from 'types/cdnurls';
import AxiosInstanceCreator from 'services/api';
import { LoopbackFilter } from 'services/loopback';

export const cdnurlsInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_PROD_API_URL}/api/v1/cdnurls`,
  withCredentials: true,
}).create();

export const cdnurlsAPI = {
  cdnurls: (filter: LoopbackFilter): Promise<ResponseCdnurls[]> => {
    return cdnurlsInstance
      .get('', {
        params: { filter },
      })
      .then((res) => res.data);
  },
};
