import AxiosInstanceCreator from 'services/api';
import { LoopbackFilter, LoopbackWhere } from 'services/loopback';
import { ResponseProfile, ResponsesLogin, UpdatePassword, UpdateUser } from 'types/auth';

export const authInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_API_URL}/api/v1/users`,
  withCredentials: true,
}).create();

export const authAPI = {
  login: ({ email, password }: { email: string; password: string }): Promise<ResponsesLogin> => {
    return authInstance.post('/login', { email, password }).then((res) => {
      return res.data;
    });
  },
  logout: (): Promise<void> => {
    return authInstance.post('/logout').then((res) => res.data);
  },
  profile: (accessToken: string): Promise<ResponseProfile> => {
    return authInstance
      .get('/profile', {
        params: {
          access_token: accessToken,
        },
      })
      .then((res) => res.data);
  },

  list: (filter: LoopbackFilter): Promise<ResponseProfile[]> => {
    return authInstance.get('', { params: { filter } }).then((res) => res.data);
  },

  count: (where: LoopbackWhere): Promise<{ count: number }> => {
    return authInstance.get('/count', { params: { where } }).then((res) => res.data);
  },

  patch: (id: string, data: UpdateUser): Promise<ResponseProfile> => {
    return authInstance
      .patch(`/${id}`, null, {
        data,
      })
      .then((res) => res.data);
  },
  updatePassword: (params: UpdatePassword): Promise<boolean> => {
    return authInstance.put('/password', { params }).then((res) => {
      if (res.data.statusCode === 401) {
        throw new Error('비밀번호가 맞지 않습니다. 비밀번호를 확인해주세요.');
      }
      return res.data;
    });
  },
};
