"use strict";

module.exports = function (User) {
  delete User.validations.username;

  User.observe("before save", function (context, next) {
    const updatedDate = new Date();
    const _instance = context.instance;

    if (_instance) {
      _instance.created = updatedDate;
      _instance.updated = updatedDate;
    } else {
      if (!context.currentInstance) {
        return next();
      } else {
        context.data.updated = updatedDate;
      }
    }

    return next();
  });

  User.beforeRemote("find", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  User.beforeRemote("count", function (context, modelInstance, next) {
    if (!context.args.where) {
      context.args.where = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.where) {
      if (context.args.where.and) {
        context.args.where.and.push(_where);
      } else {
        context.args.where = {
          and: [context.args.where, _where],
        };
      }
    } else {
      context.args.where = _where;
    }

    return next();
  });

  User.beforeRemote("login", function (context, modelInstance, next) {
    context.args.credentials[
      "email"
    ] = `${context.args.credentials["email"]}@${context.args.credentials["email"]}.com`;
    return next();
  });

  User.profile = (req, cb) => {
    return cb(null, req.userInfo);
  };

  User.updateUserPassword = (params, cb) => {
    User.login({
      email: params.email,
      password: params.oriPassword,
    })
      .then((token) => {
        if (!token.id) {
          throw "invalid password";
        }

        return User.findOne({
          where: {
            email: params.email,
          },
        });
      })
      .then((result) => {
        if (!result) {
          throw "WRONG PARAMETER";
        }

        return new Promise((resolve, reject) => {
          result.updateAttribute("password", params.password, (err, user) => {
            if (err) {
              reject(err);
            }
            resolve(user);
          });
        });
      })
      .then((user) => {
        if (!user) {
          throw "bad request";
        }

        User.upsertWithWhere(
          {
            email: params.email,
          },
          {
            lockCount: 0,
          }
        );
        return cb(null, true);
      })
      .catch((error) => {
        return cb(error);
      });
  };
};
