"use strict";

module.exports = function (LogAccess) {
  const { getUrlParams } = require("../utils");
  const moment = require("moment");
  const app = require("../../server/server");

  LogAccess.observe("before save", function (context, next) {
    const updatedDate = moment().format("YYYY-MM-DD HH:mm:ss");
    const _instance = context.instance;

    if (_instance) {
      _instance.created = updatedDate;
      _instance.updated = updatedDate;
      _instance.lastAccess = updatedDate;
    } else {
      if (!context.currentInstance) {
        return next();
      } else {
        context.data.updated = updatedDate;
      }
    }

    return next();
  });

  LogAccess.beforeRemote("find", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {};

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  LogAccess.beforeRemote("count", function (context, modelInstance, next) {
    if (!context.args.where) {
      context.args.where = {};
    }

    let _where = {};

    if (context.args.where) {
      if (context.args.where.and) {
        context.args.where.and.push(_where);
      } else {
        context.args.where = {
          and: [context.args.where, _where],
        };
      }
    } else {
      context.args.where = _where;
    }

    return next();
  });

  LogAccess.push = (url, isGA, req, cb) => {
    const oriUrl = url;
    const decodeUrl = Buffer.from(url, "base64").toString("utf8");
    const splitDecodeUrl = decodeUrl.split(/2741\w{8}/);
    const fpId = splitDecodeUrl[0];

    if (!fpId || (fpId.length === 7 && fpId.length === 8)) {
      return cb({
        statusCode: 400,
        message: "invalid query",
      });
    }

    const branchCode = splitDecodeUrl[1];
    const lastAccess = moment().format("YYYY-MM-DD HH:mm:ss");

    LogAccess.findOne({
      where: { fpId },
    })
      .then((result) => {
        if (result) {
          return LogAccess.updateAll(
            { fpId },
            {
              oriUrl,
              lastAccess,
              isGA: isGA === "true",
            }
          );
        }

        return LogAccess.create({
          oriUrl,
          fpId,
          branchCode,
          lastAccess,
          isGA: isGA === "true",
        });
      })
      .then(() => {
        return cb(null, {
          oriUrl,
          fpId,
          branchCode,
          lastAccess,
          isGA: isGA === "true",
        });
      })
      .catch((err) => {
        return cb(err);
      });
  };

  LogAccess.check = (q, cb) => {
    const decodeUrl = Buffer.from(q, "base64").toString("utf8");
    const UserModel = app.models.usersData;

    const splitDecodeUrl = decodeUrl.split(/2741\w{8}/);
    const fpId = splitDecodeUrl[0];

    if (!fpId || (fpId.length === 7 && fpId.length === 8)) {
      return cb({
        statusCode: 400,
        message: "invalid query",
      });
    }

    let result = {};

    LogAccess.findOne({
      where: {
        fpId,
      },
    })
      .then((res) => {
        if (!res) {
          throw "no lastAccess";
        }

        result = res;
      })
      .then(() => {
        return UserModel.findOne({
          where: {
            employee_id: fpId,
          },
        });
      })
      .then((res) => {
        const diff = moment().diff(result.lastAccess, "days");
        cb(null, {
          lastMonthAccess: diff <= 180,
          lastAccess: result.lastAccess,
          isGA: !!result.isGA,
          target: res && res.title ? res.title : "",
          branchCode: res && res.branch_code ? res.branch_code : "",
        });
      })
      .catch((err) => {
        if (err === "no lastAccess") {
          return cb(null, {
            lastMonthAccess: false,
          });
        }

        cb(err);
      });
  };
};
