const app = require("../../server/server");
const ilog = require("../logger").ilog;

module.exports = function () {
  return (req, res, next) => {
    const tempUrl = req.method + " " + req.url.split("?")[0];
    const _headers = JSON.stringify(req.headers ? req.headers : {});
    const _query = JSON.stringify(req.query ? req.query : {});
    const _body = JSON.stringify(req.body ? req.body : {});
    const _url = JSON.stringify(tempUrl ? tempUrl : {});

    ilog.info(_url + " " + _headers + " " + _query + " " + _body);

    const User = app.models.user;

    if (!req.accessToken) {
      return next();
    }

    User.findOne({ where: { id: req.accessToken.userId } })
      .then((res) => {
        if (!res) {
          throw "no user";
        }

        req["userInfo"] = res;
        return next();
      })
      .catch((err) => {
        return next(err);
      });
  };
};
