require("dotenv").config({ path: __dirname.replace("/scripts", "/.env") });

const moment = require("moment");
const MongoClient = require("mongodb").MongoClient;
const dbHost =
  "mongodb://" +
  process.env.DB_USER +
  ":" +
  process.env.DB_PWD +
  "@" +
  process.env.DB_HOST +
  ":" +
  process.env.DB_PORT +
  "/" +
  process.env.DB_NAME;

MongoClient.connect(
  dbHost,
  {
    useNewUrlParser: true,
    useUnifiedTopology: true,
  },
  function (err, database) {
    if (err) {
      return;
    }

    const db = database.db(process.env.DB_NAME);
    const logActions = db.collection("log_actions");
    const statistics = db.collection("statistics");
    const startAt = moment().startOf("date").toISOString();
    const endAt = moment().endOf("date").toISOString();

    console.log(`started script`);
    console.log(`start: ${startAt}`);
    console.log(`end: ${endAt}`);

    logActions
      .find({
        $and: [
          {
            created: {
              $gte: new Date(startAt),
            },
          },
          {
            created: {
              $lte: new Date(endAt),
            },
          },
        ],
      })
      .toArray()
      .then((log) => {
        const logMap = {};

        log.forEach((x) => {
          if (!x.employee_id) return;

          if (!logMap[x.employee_id]) {
            logMap[x.employee_id] = {
              video: 0,
              document: 0,
              main: 0,
            };
          }
          const type = x.branch.includes("한화라이프랩")
            ? "한화라이프랩"
            : x.branch.includes("한화생명금융서비스")
            ? "한화생명금융서비스"
            : x.title;

          logMap[x.employee_id] = {
            area: x.area,
            branch: x.branch,
            employee_id: x.employee_id,
            l2_name: x.l2_name,
            name: x.name,
            region: x.region,
            video:
              x.action === "video"
                ? logMap[x.employee_id]["video"] + 1
                : logMap[x.employee_id]["video"],
            document:
              x.action === "document"
                ? logMap[x.employee_id]["document"] + 1
                : logMap[x.employee_id]["document"],
            main:
              x.action === "main"
                ? logMap[x.employee_id]["main"] + 1
                : logMap[x.employee_id]["main"],
            updated: new Date(x.updated),
            created: new Date(x.created),
            type,
          };
        });

        return Object.values(logMap);
      })
      .then((result) => {
        if (result.length) {
          return statistics.insertMany(result);
        }
      })
      .catch((err) => {
        console.log(err);
      })
      .finally(() => {
        database.close();
      });
  }
);
