"use strict";

module.exports = function (Video) {
  const { encrypt, getRandomInt, decrypt } = require("../utils");
  const app = require("../../server/server");
  const moment = require("moment");

  Video.observe("before save", function (context, next) {
    const updatedDate = new Date();
    const _instance = context.instance;

    if (_instance) {
      _instance.created = updatedDate;
      _instance.updated = updatedDate;
    } else {
      if (!context.currentInstance) {
        return next();
      } else {
        context.data.updated = updatedDate;
      }
    }

    return next();
  });

  Video.beforeRemote("find", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  Video.beforeRemote("count", function (context, modelInstance, next) {
    if (!context.args.where) {
      context.args.where = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.where) {
      if (context.args.where.and) {
        context.args.where.and.push(_where);
      } else {
        context.args.where = {
          and: [context.args.where, _where],
        };
      }
    } else {
      context.args.where = _where;
    }

    return next();
  });

  Video.oneTimeUrl = (cdnCtntSeq, fpId, req, cb) => {
    const CdnUrls = app.models.cdnurls;
    CdnUrls.findOne({
      where: {
        cdnCtntSeq,
      },
    })
      .then((result) => {
        if (!result) {
          throw "not CdnUrls";
        }

        const { ctntUrl } = result;
        const ip =
          req.headers["x-forwarded-for"] || req.connection.remoteAddress;
        const limitTime = moment().add(24, "hours").format("YYYYMMDDHHmmSS");
        const targetUrl = `${ctntUrl}?r=${getRandomInt(
          10,
          99
        )}&ip=${ip}&limitTime=${limitTime}&userNo=${fpId}&checkIP=true`;
        const oneTimeUrl = encrypt(targetUrl);

        return cb(null, `${process.env.CDN_URL}/${oneTimeUrl}`);
      })
      .catch((err) => {
        return cb(err);
      });
  };
};
