"use strict";

module.exports = function (usersData) {
  const app = require("../../server/server");
  const formidable = require("formidable");
  const XLSX = require("xlsx");

  usersData.observe("before save", function (context, next) {
    const updatedDate = new Date();
    const _instance = context.instance;

    if (_instance) {
      _instance.created = updatedDate;
      _instance.updated = updatedDate;
    } else {
      if (!context.currentInstance) {
        return next();
      } else {
        context.data.updated = updatedDate;
      }
    }

    return next();
  });

  usersData.beforeRemote("find", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  usersData.beforeRemote("count", function (context, modelInstance, next) {
    if (!context.args.where) {
      context.args.where = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.where) {
      if (context.args.where.and) {
        context.args.where.and.push(_where);
      } else {
        context.args.where = {
          and: [context.args.where, _where],
        };
      }
    } else {
      context.args.where = _where;
    }

    return next();
  });

  usersData.existsCheck = (employee_id, cb) => {
    usersData
      .findOne({
        where: {
          employee_id,
        },
      })
      .then((result) => {
        if (!result) {
          throw {
            statusCode: 400,
            message: "입력하신 사번이 존재하지 않습니다.",
          };
        }

        return cb(null, result);
      })
      .catch((err) => {
        return cb(err);
      });
  };

  usersData.uploadFile = (req, res, cb) => {
    const form = formidable.IncomingForm();
    let fileName = "";
    form.parse(req, async (err, fields, files) => {
      if (err) {
        return cb(err);
      }

      const validSheetNames = ["한화생명금융서비스", "한화라이프랩", "GA"];

      const f = files[Object.keys(files)[0]];
      const wb = XLSX.readFile(f.path);
      const createResult = [];
      fileName = f.name;

      await wb.SheetNames.reduce((prev, sheet) => {
        return prev.then(async () => {
          if (!validSheetNames.includes(sheet)) throw "invalid sheetName";

          const title = sheet;
          const ws = wb.Sheets[title];
          const data = XLSX.utils.sheet_to_json(ws, { header: 1 });
          const checkEmployeeIdPromiseAll = [];

          for (let i = 1; i < data.length; i++) {
            const v = data[i];
            const l1_name = v[0] ? `${v[0]}`.trim() : null;
            const l1_code = v[1] ? `${v[1]}`.trim() : null;
            const l2_name = v[2] ? `${v[2]}`.trim() : null;
            const l2_code = v[3] ? `${v[3]}`.trim() : null;
            const region = v[4] ? `${v[4]}`.trim() : null;
            const region_code = v[5] ? `${v[5]}`.trim() : null;
            const area = v[6] ? `${v[6]}`.trim() : null;
            const area_code = v[7] ? `${v[7]}`.trim() : null;
            const branch = v[8] ? `${v[8]}`.trim() : null;
            const branch_code = v[9] ? `${v[9]}`.trim() : null;
            const employee_id = v[10] ? `${v[10]}`.trim() : null;
            const name = v[11] ? `${v[11]}`.trim() : null;

            checkEmployeeIdPromiseAll.push(
              usersData
                .findOne({
                  where: { employee_id },
                })
                .then((exists) => {
                  if (exists) {
                    return {
                      employee_id,
                      exists: true,
                    };
                  }

                  return {
                    employee_id,
                    title,
                    l1_name,
                    l1_code,
                    l2_name,
                    l2_code,
                    region,
                    region_code,
                    area,
                    area_code,
                    branch,
                    branch_code,
                    employee_id,
                    fileName,
                    name,
                  };
                })
            );
          }

          return Promise.all(checkEmployeeIdPromiseAll);
        });
      }, Promise.resolve())
        .then((users) => {
          const noExistsUser = users.filter((user) => !user.exists);
          if (noExistsUser.length) {
            return usersData.create(noExistsUser);
          }

          return false;
        })
        .then(() => {
          return cb(null, { fileName });
        })
        .catch((err) => {
          return cb(err);
        });
    });
  };

  usersData.deleteAllData = (req, res, cb) => {
    usersData
      .destroyAll({ default: { neq: true } })
      .then((result) => {
        return cb(null, result);
      })
      .catch((err) => {
        return cb(err);
      });
  };
};
