"use strict";

module.exports = function (Cdnurls) {
  Cdnurls.observe("before save", function (context, next) {
    const updatedDate = new Date();
    const _instance = context.instance;

    if (_instance) {
      _instance.created = updatedDate;
      _instance.updated = updatedDate;
    } else {
      if (!context.currentInstance) {
        return next();
      } else {
        context.data.updated = updatedDate;
      }
    }

    return next();
  });

  Cdnurls.beforeRemote("find", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  Cdnurls.beforeRemote("count", function (context, modelInstance, next) {
    if (!context.args.where) {
      context.args.where = {};
    }

    let _where = {
      status: { neq: "inactive" },
    };

    if (context.args.where) {
      if (context.args.where.and) {
        context.args.where.and.push(_where);
      } else {
        context.args.where = {
          and: [context.args.where, _where],
        };
      }
    } else {
      context.args.where = _where;
    }

    return next();
  });

  Cdnurls.callback = (req, res, cb) => {
    const { cdnCtntSeq, ...query } = req.query;

    if (!cdnCtntSeq) {
      return cb("not found cdnCtntSeq");
    }

    Cdnurls.findOne({
      where: {
        cdnCtntSeq,
      },
    })
      .then((result) => {
        if (result) {
          return Cdnurls.updateAll(
            {
              cdnCtntSeq,
            },
            {
              ...query,
            }
          );
        }
        return Cdnurls.create({ cdnCtntSeq, ...query });
      })
      .then(() => {
        return res.send(
          `<script>alert('저장 완료.\\n동영상 관리에서 글 등록 후 선택해주세요.');window.close();</script>`
        );
      })
      .catch((err) => {
        return cb(err);
      });
  };
};
