export enum ErrorCode {
  AUTHORIZATION_REQUIRED = 'AUTHORIZATION_REQUIRED',
  HW40000 = 'HW40000',
  HW40001 = 'HW40001',
  HW40003 = 'HW40003',
  HW40004 = 'HW40004',
  HW40009 = 'HW40009',
  HW40022 = 'HW40022',
  HW50001 = 'HW50001',
  HW50000 = 'HW50000',
}

export const CommonMsg = '관리자에게 문의하세요';

export const errorCodeMethods = {
  getErrorMsg: (key: string) => {
    switch (key) {
      case ErrorCode.AUTHORIZATION_REQUIRED:
        return '사용자 인증에 실패하였습니다.';
      case ErrorCode.HW40000:
      case ErrorCode.HW40004:
        return `잘못된 요청입니다.`;
      case ErrorCode.HW40001:
        return `사용자 인증에 실패하였습니다.`;
      case ErrorCode.HW40003:
        return `잘못된 권한입니다.`;
      case ErrorCode.HW40009:
        return `중복된 데이터입니다.`;
      case ErrorCode.HW40022:
        return `잘못된 요청입니다.`;
      case ErrorCode.HW50001:
        return `해당 데이터가 없습니다.`;
      default:
        return `서버 오류 입니다. ${CommonMsg}`;
    }
  },
};
