import styled from 'styled-components';
import { Menu } from 'antd';

export const StatisticsListWrap = styled.section`
  margin-top: 10px;

  .statistics_wrap {
    margin-top: 10px;
    background: #fff;
    padding: 25px 30px;
    border: 1px solid rgba(0, 0, 0, 0.1);
  }

  .ant-menu-horizontal > .ant-menu-item {
    color: #bdbdbd;
  }
  .ant-menu-horizontal > .ant-menu-item::after,
  .ant-menu-horizontal > .ant-menu-item:hover::after {
    border: none;
  }
  .ant-menu-horizontal > .ant-menu-item-selected {
    color: #fff;
    background: #f47320;
    font-weight: bold;
  }
  .ant-menu-horizontal > .ant-menu-item-selected:hover {
    color: #fff;
  }
`;

export const SearchDiv = styled.section`
  display: flex;
  flex-direction: row;
  align-items: center;
  padding: 10px 0;
  border-bottom: 1px solid #eee;
  .item_title {
    width: 15%;
  }
`;

export const ButtonWrap = styled.section`
  text-align: center;
  button {
    width: 10%;
  }
  button + button {
    margin-left: 10px;
  }
`;

export const ListMenuWrap = styled(Menu)`
  display: flex;
  margin-top: 20px;
  div {
    background: #fff;
    width: 120px;
    height: 48px;
    display: flex;
    justify-content: center;
    align-items: center;
    border: 1px solid #eee;
    color: #bdbdbd;
    cursor: pointer;
    &:hover {
      background: #f47320;
      border: 1px solid #f47320;
      color: #fff;
      font-weight: bold;
    }
  }
  div.on {
    background: #f47320;
    border: 1px solid #f47320;
    color: #fff;
    font-weight: bold;
  }
`;

export const TableWrap = styled.div`
  background-color: #fff;
  padding: 25px 30px 15px;
  border: 1px solid rgba(0, 0, 0, 0.1);

  .ant-table {
    border: 1px solid rgba(0, 0, 0, 0.03);
  }

  .ant-table-thead > tr > th,
  .ant-table-tbody > tr > td {
    text-align: center;
    letter-spacing: -0.5px;
    padding: 10px;
  }
`;
