import XLSX from 'xlsx';

export const downloadExcel = (listData: any, sheetName: any, fileName: string, toCsv = false) => {
  const ws = XLSX.utils.aoa_to_sheet(listData);
  const wb = XLSX.utils.book_new();
  sheetName.forEach((item: string) => {
    XLSX.utils.book_append_sheet(wb, ws, item);
  });

  toCsv ? XLSX.writeFile(wb, `${fileName}.csv`) : XLSX.writeFile(wb, `${fileName}.xlsx`);
};

export const maskingStr = (str?: string) => {
  if (!str) return;

  if (str.length > 2) {
    var originName = str.split('').map((v, i, oriArr) => {
      if (i === 0 || i === oriArr.length - 1) return v;
      return '*';
    });
    var joinName = originName.join();
    return joinName.replace(/,/g, '');
  }

  var pattern = /.$/; // 정규식
  return str.replace(pattern, '*');
};
