// base
import React, { useEffect, useState } from 'react';

// store
import { authProfileSelector } from 'store/selector';

// libraries
import { Menu } from 'antd';
import { Link, useLocation } from 'react-router-dom';
import { useRecoilValue } from 'recoil';

// style
import { StyledMainMenu } from './style';
import { menuData } from 'consts';

interface MenuType {
  [key: string]: {
    title: string;
  };
}

export const MainNav: React.FC = () => {
  const profile = useRecoilValue(authProfileSelector);
  const [openKeys, setOpenkeys] = useState<string[]>();
  const [selectedKeys, setSelectedKeys] = useState<string[]>();
  const [roots, setRoots] = useState<string[]>([]);
  const [menuType, setMenuType] = useState<MenuType>({});
  const location = useLocation();

  useEffect(() => {
    setOpenkeys([]);
    setSelectedKeys([]);
  }, []);

  useEffect(() => {
    if (profile) {
      const menu = menuData;
      setRoots(Object.keys(menu));
      setMenuType(menu);
    }
  }, [profile]);

  useEffect(() => {
    let pathname = location.pathname;
    if (pathname === '/') {
      pathname = '/video';
    }

    const splitPath = pathname.split(/(?=\/)/g);
    const openKey = [splitPath[0]];

    setSelectedKeys([pathname]);
    setOpenkeys(openKey);
  }, [location.pathname]);

  if (!selectedKeys) {
    return <></>;
  }

  return (
    <StyledMainMenu>
      <Menu
        key="mainMenu"
        theme="dark"
        mode="inline"
        openKeys={openKeys}
        selectedKeys={selectedKeys}
        onOpenChange={(openKeys) => setOpenkeys(openKeys as string[])}
      >
        {roots.map((root) => {
          if (!menuType[root]) {
            return null;
          }

          return (
            <Menu.Item key={`/${root}`}>
              <Link to={`/${root}`}>{menuType[root].title}</Link>
            </Menu.Item>
          );
        })}
      </Menu>
    </StyledMainMenu>
  );
};
