import AxiosInstanceCreator from 'services/api';
import { LoopbackFilter, LoopbackWhere } from 'services/loopback';

import { ResponseUsersDataUpload, UsersDataUploadData } from 'types/usersData';

export const usersDataUploadInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_API_URL}/api/v1/log_usersDataUpload`,
  withCredentials: true,
}).create();

export const usersDataUploadAPI = {
  get: (filter: LoopbackFilter): Promise<ResponseUsersDataUpload[]> => {
    return usersDataUploadInstance.get('', { params: { filter } }).then((res) => res.data);
  },
  create: (data: UsersDataUploadData) => {
    return usersDataUploadInstance.post('', data).then((res) => res.data);
  },
  count: (where: LoopbackWhere): Promise<{ count: number }> => {
    return usersDataUploadInstance.get('/count', { params: { where } }).then((res) => res.data);
  },
};
