// base
import { Suspense, useCallback, useEffect } from 'react';

// components
import { PageLoader } from 'components';
import { NotFoundResult } from 'components/Results';

// pages
import { LoginPage } from 'pages';

// routes
import { ROUTE_LOGIN } from 'routes/const';
import { routes } from 'routes';

// apis
import { authAPI } from 'apis/auth';

// services
import { STORAGE_SESSION_ACT } from 'services/storage';

// recoil
import { useRecoilState } from 'recoil';
import { authProfileSelector } from 'store/selector';

// libraries
import { Route, Routes, useNavigate } from 'react-router-dom';
import { ConfigProvider } from 'antd';
import ko_KR from 'antd/es/locale/ko_KR';

const App = () => {
  const navigate = useNavigate();
  const [profile, setProfile] = useRecoilState(authProfileSelector);
  const act = sessionStorage.getItem(STORAGE_SESSION_ACT);
  const getProfile = useCallback(async () => {
    if (act) {
      const profile = await authAPI.profile(act);
      setProfile(profile);
    } else {
      navigate(ROUTE_LOGIN);
    }
  }, [setProfile, navigate, act]);

  useEffect(() => {
    if (!profile?.id) {
      getProfile();
    }
  }, [getProfile, profile]);

  return (
    <ConfigProvider locale={ko_KR}>
      <div className="App">
        <Suspense fallback={<PageLoader />}>
          <Routes>
            <Route path={ROUTE_LOGIN} element={<LoginPage />} />
            {routes.common.map((item, index) => (
              <Route key={index} path={item.path} element={<item.component />} />
            ))}
            <Route path="*" element={<NotFoundResult />} />
          </Routes>
        </Suspense>
      </div>
    </ConfigProvider>
  );
};

export default App;
