$(document).ready(function () {
  if (getParameterByName('detail')) {
    getDetail(getParameterByName('detail'));
    return;
  }
  setTimeout(function () {
    getList();
  }, 250);
});

function getList() {
  $('.list-wrap, .welcome-text .back-btn').css('display', 'block');
  $('.detail').css('display', 'none');

  ajaxGet(API_HOST + '/api/v1/video', {
    filter: {
      order: 'creted desc',
      where: {
        type:
          USER_DATA.branchCode === '00587' ? undefined : USER_DATA.isGA ? 'GA' : USER_DATA.target,
      },
    },
  })
    .then(function (result) {
      setListItems(result);
    })
    .then(function () {
      return ajaxPost(API_HOST + '/api/v1/log_actions/action', {
        fp: getQueryData().fp_id,
        action: 'main',
      });
    })
    .catch(function (error) {
      // alert('데이터를 확인할 수 없습니다. 관리자에게 문의해주세요.');
      location.href = '/';
    });
}

function setListItems(data) {
  var listItemsHtml = '';

  data.forEach(function (item) {
    if (!item.expose) return;

    var items =
      '<div class="item" id="' +
      item.id +
      '"><div class="dim"></div><div class="item-thumb" style="background: url(' +
      item.imgFileUrl +
      ') no-repeat top center / cover"></div><div class="item-text">' +
      item.title +
      '</div></div>';

    listItemsHtml += items;
  });

  $('.list').append(listItemsHtml);
  $('.item').on('click', function () {
    onClickItems(this.id);
  });
}

function onClickItems(detailId) {
  location.href = './?detail=' + detailId;
}

function replaceRem(match) {
  const num = parseInt(match.split(':')[1].split('px')[0]);
  return 'font-size: ' + (num / 10) * 2 + 'rem';
}

function getDetail(itemId) {
  $('.list-wrap, .welcome-text, .back-btn').css('display', 'none');
  $('.detail').css('display', 'block');

  var result = {};
  ajaxGet(API_HOST + '/api/v1/video/' + itemId)
    .then(function (res) {
      result = res;
      return videoOneTimeUrl(res.cdnCtntSeq, fp_id);
    })
    .then(function (video) {
      var video = video;
      setDetailPage(result, video);
    })
    .catch(function (error) {
      $('.detail').append('<div>페이지가 존재하지 않습니다.</div>');
    });
}

function setDetailPage(data, video) {
  var detailHtml =
    '<div class="detail-back-btn"></div>' +
    '<div class="video-area">' +
    '<div id="popup_layer_player" class="popup_layer">' +
    '<div id="playerBox"></div>' +
    '</div><form id="load-url"><input id="url" type="url" value="' +
    video +
    '"/></form></div>' +
    '<section class="video-text"><div class="video-title">' +
    data.title +
    '</div><div class="video-date">' +
    data.created.split('T')[0] +
    '  ' +
    data.created.split('T')[1].split('.')[0] +
    '</div><div class="video-dec"> ' +
    data.content.replace(/font-size: \d{1,2}px/g, replaceRem) +
    '</div></section>';

  $('.detail').prepend(detailHtml);
  $('#load-url').submit(function (event) {
    event.preventDefault();
    play();
    return false;
  });
  play();

  function play() {
    ajaxPost(API_HOST + '/api/v1/log_actions/action', {
      fp: getQueryData().fp_id,
      action: 'video',
    })
      .then(() => {
        $('#playerBox').gmediaVideoPlugin({
          vodUrl: $('#url').val(),
        });
      })
      .catch(function (error) {
        alert('데이터를 확인할 수 없습니다. 관리자에게 문의해주세요.');
        location.href = '/';
      });
  }

  $('.detail-back-btn').on('click', function () {
    location.href = '../';
  });
}

function videoOneTimeUrl(cdnCtntSeq, fpId) {
  return new Promise(function (resolve, reject) {
    ajaxPost(PRD_API_HOST + '/api/v1/video/oneTimeUrl', {
      cdnCtntSeq: cdnCtntSeq,
      fpId: getQueryData().fp_id,
    })
      .then(function (result) {
        resolve(result);
      })
      .catch(function (error) {
        reject(error);
      });
  });
}

$('nav li').on('click', function () {
  if (this.id === 'video') {
    return;
  }

  location.href = '../' + this.id;
});
