$(document).ready(function () {
  var GLOBAL_FONTSIZE_KEY = 'GLOBAL_FONTSIZE_KEY';
  var GLOBAL_FONTSIZE = localStorage.getItem(GLOBAL_FONTSIZE_KEY);

  if (GLOBAL_FONTSIZE) {
    setGlobalFontSize(GLOBAL_FONTSIZE);
  } else {
    localStorage.setItem(GLOBAL_FONTSIZE_KEY, '10px');
  }

  $('body').append(
    '<div class="floating" style="position:fixed; bottom: 80px; left: 50%; transform: translateX(200px); cursor:pointer;"><img src="../assets/icons/floating.png" /></div>'
  );

  $(document).on('click', '.floating', onClickFloatingListOpen);
  $(document).on('click', '.floating-btn', onClickFloatingBtn);
  $(document).on('click', '.closeFloating-btn', onClickFloatingClose);

  function onClickFloatingListOpen() {
    $('.floating').hide();

    $('body')
      .append(
        '<div class="dim" style="width: 100%; height: 100%; background:rgba(0,0,0,0.5); position:fixed; top:0; left:0;"></div>'
      )
      .append(
        '<div class="floating_list" style="width:156px; height:430px; position:fixed; bottom: 160px; left: 50%; transform: translateX(200px);">' +
          '<div class="floating-btn" data-font-size="10px" style="cursor:pointer; width:105px; height: 105px; background: #fff; text-align:center; margin:10px auto; line-height:98px; border-radius: 100%; font-size: 28px;">가</div>' +
          '<div class="floating-btn" data-font-size="11px" style="cursor:pointer; width:105px; height: 105px;background:#fff; font-weight: 500; text-align:center;margin:10px auto; line-height:98px; border-radius: 100%;  font-size: 36px;">가</div>' +
          '<div class="floating-btn" data-font-size="12px" style="cursor:pointer; width:105px; height: 105px;background:#fff; font-weight: 700; border-radius: 100%; margin:10px auto;text-align:center; line-height:98px;font-size:42px;">가</div>' +
          '<div class="closeFloating-btn" style="cursor:pointer; width:100%; height: 156px; text-align:center;"><img src="../assets/icons/floating_close.png"/></div>' +
          '</div>'
      );

    if (localStorage.getItem(GLOBAL_FONTSIZE_KEY)) {
      setFloatingBtnActive(localStorage.getItem(GLOBAL_FONTSIZE_KEY));
    }
  }

  function onClickFloatingClose() {
    $('.floating_list').hide();
    $('.dim').hide();
    $('.floating').show();
  }

  function onClickFloatingBtn(fontSize) {
    var fontSize = $(this).data('font-size');
    setGlobalFontSize(fontSize);
  }

  function setGlobalFontSize(fontSize) {
    localStorage.setItem(GLOBAL_FONTSIZE_KEY, fontSize);
    $('html').css('font-size', fontSize);
    setFloatingBtnActive(fontSize);
  }

  function setFloatingBtnActive(fontSize) {
    $('.floating-btn')
      .not('.floating-btn[data-font-size=' + fontSize + ']')
      .css('color', '#000');

    $('.floating-btn[data-font-size=' + fontSize + ']').css('color', '#ed702d');
  }
});
