var pdfDoc = null,
  pageNum = 1,
  totalPageNum = 1,
  pageRendering = false,
  pageNumPending = null,
  scale = 1,
  canvas = {},
  ctx = {};

var pdfjsLib = window['pdfjs-dist/build/pdf'];

pdfjsLib.GlobalWorkerOptions.workerSrc = '/lib/pdf.worker.js';

$(document).ready(function () {
  if (getParameterByName('id')) {
    getListById(getParameterByName('id'));
    return;
  }

  location.href = '../';
});

$(document).on('click', '.modal .close-btn', function () {
  location.href = '../';
});

function getListById(id) {
  ajaxGet(API_HOST + '/api/v1/document/' + id)
    .then(function (result) {
      if (result.statusCode === 404) {
        throw result.statusCode;
      }

      insertPdfModal(result);
    })
    .then(function () {
      return ajaxPost(API_HOST + '/api/v1/log_actions/action', {
        fp: getQueryData().fp_id,
        action: 'document',
      });
    })
    .catch(function (error) {
      if (error === 404) {
        $('.loader-wrap').css({ display: 'none' });
      }

      alert(
        '데이터를 확인할 수 없습니다. 관리자에게 문의해주세요. \n' + JSON.stringify(location.href)
      );
      location.href = '/docs';
    });
}

function insertPdfModal(item) {
  if (!item.exposure) return;

  ajaxPost(API_HOST + '/api/v1/document/readFile', {
    id: item.id,
    fileName: item.fileName,
    fileKey: item.fileKey,
  })
    .then((result) => {
      if (result === 'no file') {
        alert('파일을 확인할 수 없습니다. 관리자에게 문의해주세요.');
        location.href = '/docs';
        return;
      }

      pdfDoc = null;
      pageNum = 1;
      pageRendering = false;
      pageNumPending = null;

      // var pdfViewer =
      //   '<iframe width="100%" height="100%" src="data:application/pdf;base64,' +
      //   result +
      //   '#toolbar=0"></iframe>';
      // $('.pdf').html('');
      // $('.pdf').append(pdfViewer);
      // $('.loader-wrap').css({ display: 'none' });

      pdfjsLib
        .getDocument({ data: window.atob(result), cMapUrl: '/assets/cmaps/' })
        .promise.then(function (pdfDoc_) {
          pdfDoc = pdfDoc_;
          totalPageNum = pdfDoc.numPages;
          for (var page = 1; page <= pdfDoc.numPages; page++) {
            $('.modal').append(
              '<canvas oncontextmenu="return false" onselect="return false" onkeydown="return false"  id="the-canvas' +
                page +
                '"></canvas>'
            );

            canvas['num' + page] = document.getElementById('the-canvas' + page);
            ctx['num' + page] = canvas['num' + page].getContext('2d');
            renderPage(page);
          }

          // document.getElementById('page_count').textContent = pdfDoc.numPages;
        });
    })
    .catch(function (error) {
      alert('파일을 확인할 수 없습니다. 관리자에게 문의해주세요.');
      location.href = '/docs';
    });
}

function renderPage(num) {
  pageRendering = true;

  pdfDoc.getPage(num).then(function (page) {
    var viewport = page.getViewport({ scale: scale });
    canvas['num' + num].height = viewport.height;
    canvas['num' + num].width = viewport.width;

    var renderContext = {
      canvasContext: ctx['num' + num],
      viewport: viewport,
    };
    var renderTask = page.render(renderContext);

    renderTask.promise.then(function () {
      pageRendering = false;

      // if (num === 1) {
      $('.loader-wrap').css({ display: 'none' });
      // }

      if (pageNumPending !== null) {
        renderPage(pageNumPending);
        pageNumPending = null;
      }
    });
  });

  // document.getElementById('page_num').textContent = num;
}

function queueRenderPage(num) {
  if (pageRendering) {
    pageNumPending = num;
  } else {
    renderPage(num);
  }
}

function onPrevPage() {
  if (pageNum <= 1) {
    return;
  }
  pageNum--;
  queueRenderPage(pageNum);
}

function onNextPage() {
  if (pageNum >= pdfDoc.numPages) {
    return;
  }
  pageNum++;
  queueRenderPage(pageNum);
}
