var fp_id;

var SESSION_KEY = 'prevUrl';

var gaLoginPage = GA_URL + '/edu';

// var cookie = 'MTExMTExMTEyNzQxMDMxOTI2NTgyOTQ2NA';
var cookie = getCookie('userCheck');
var qs = getQueryStringObject();
var queryData = qs.q;
var USER_DATA = {};

if (queryData) {
  checkLogAccess({ q: queryData, replace: true });
} else if (cookie) {
  $('#wrapper').css('display', 'block');
  var prevUrl = sessionStorage.getItem(SESSION_KEY);
  checkLogAccess({ q: cookie, replace: false, prevUrl: prevUrl });
} else {
  sessionStorage.setItem(SESSION_KEY, location.href);
  location.replace(gaLoginPage);
}

function checkLogAccess({ q, replace, prevUrl }) {
  ajaxGet(API_HOST + '/api/v1/log_access/check/' + q + '')
    .then(function (result) {
      USER_DATA = result;

      if (result.lastMonthAccess) {
        setCookie('userCheck', q, result.isGA ? 30 : 180, result.lastAccess);

        history.pushState(null, null, location.href);
        window.onpopstate = function (event) {
          var qs = getQueryData();
          var date = new Date(+new Date() + 3240 * 10000).toISOString().split('T')[0];
          var time = new Date().toTimeString().split(' ')[0];
          var currentDDHHmmss = (date + time).replace(/\:|\-/g, '').slice(6);
          var fpId = qs.fp_id;
          var branch_code = qs.branch_code;
          var query = btoa(fpId + '2741' + currentDDHHmmss + branch_code);
          location.href = result.isGA ? GA_URL + '?q=' + query : '/';
          return;
        };

        if (result.isGA) {
          $('.back-btn').css('display', 'block');
        }

        $('.header_img, .back-btn').on('click', function () {
          var qs = getQueryData();
          var date = new Date(+new Date() + 3240 * 10000).toISOString().split('T')[0];
          var time = new Date().toTimeString().split(' ')[0];
          var currentDDHHmmss = (date + time).replace(/\:|\-/g, '').slice(6);
          var fpId = qs.fp_id;
          var branch_code = qs.branch_code;
          var query = btoa(fpId + '2741' + currentDDHHmmss + branch_code);
          location.href = result.isGA ? GA_URL + '?q=' + query : '/';
        });

        if (prevUrl) {
          sessionStorage.removeItem(SESSION_KEY);
          location.href = prevUrl;
        }

        if (replace) {
          location.href = '/';
        }
      } else {
        return location.replace(gaLoginPage);
      }
    })
    .catch(function (error) {
      console.log(error);
    });
}

function getQueryStringObject() {
  var a = window.location.search.substring(1).split('&');
  if (a == '') {
    return {};
  }

  var b = {};
  for (var i = 0; i < a.length; ++i) {
    var p = a[i].split('=', 2);
    if (p.length == 1) {
      b[p[0]] = '';
    } else {
      b[p[0]] = decodeURIComponent(p[1].replace(/\+/g, ' '));
    }
  }
  return b;
}

function ajaxGet(url, data) {
  return new Promise(function (resolve, reject) {
    $.ajax({
      type: 'GET',
      url: url,
      data: data,
      dataType: 'json',
      success: function (result) {
        resolve(result);
      },
      error: function (error) {
        reject(error);
      },
    });
  });
}

function ajaxPost(url, data) {
  return new Promise(function (resolve, reject) {
    $.ajax({
      type: 'POST',
      url: url,
      data: data,
      success: function (result) {
        resolve(result);
      },
      error: function (error) {
        reject(error);
      },
    });
  });
}

function getQueryData() {
  var querydata = getCookie('userCheck');
  var decodeQuerydata = atob(querydata);
  var fp_id = decodeQuerydata.split(/2741\w{8}/)[0];
  var branch_code = decodeQuerydata.split(/2741\w{8}/)[1];
  var timestamp = decodeQuerydata
    .substring(fp_id.length - 1)
    .match(/2741\w{8}/)[0]
    .split('2741')[1];

  return {
    fp_id: fp_id,
    branch_code: branch_code,
    timestamp: timestamp,
  };
}

function validCheckCallback(fpInfo) {
  if (fpInfo.errCode) {
    throw fpInfo.errCode;
  }

  if (fpInfo.name === 'Error') {
    throw 'err';
  }

  return fpInfo;
}

function getParameterByName(name) {
  var query = window.location.search;
  var param = new URLSearchParams(query);
  if (param.has(name)) {
    var name = param.get(name);
    return name;
  }

  return null;
}

function setCookie(name, value, exp, lastAccess) {
  var _exp = checkMobile() === 'ios' ? 7 : exp;
  var date = new Date(lastAccess.replace(' ', 'T'));
  date.setTime(date.getTime() + _exp * 24 * 60 * 60 * 1000);
  document.cookie = name + '=' + escape(value) + ';expires=' + date.toUTCString() + ';path=/';
}

function getCookie(name) {
  var value = document.cookie.match('(^|;) ?' + name + '=([^;]*)(;|$)');
  return value ? unescape(value[2]) : null;
}

function checkMobile() {
  var varUA = navigator.userAgent.toLowerCase();

  if (varUA.indexOf('android') > -1) {
    //안드로이드
    return 'android';
  } else if (
    varUA.indexOf('iphone') > -1 ||
    varUA.indexOf('ipad') > -1 ||
    varUA.indexOf('ipod') > -1
  ) {
    //IOS
    return 'ios';
  } else {
    //아이폰, 안드로이드 외
    return 'other';
  }
}
