$(document).ready(function () {
  $('nav li').on('click', function () {
    var page = location.href.split('/')[3];

    if (this.id === page) {
      return;
    }

    location.href = '../';
  });

  setTimeout(function () {
    getList();
  }, 250);
});

function getList() {
  ajaxGet(API_HOST + '/api/v1/document', {
    filter: {
      order: 'created desc',
      where: {
        target:
          USER_DATA.branchCode === '00587'
            ? undefined
            : USER_DATA.isGA
            ? 'GA'
            : USER_DATA.target === '한화생명'
            ? undefined
            : USER_DATA.target,
      },
    },
  })
    .then(function (result) {
      setListItems(result);
    })
    .then(function () {
      return ajaxPost(API_HOST + '/api/v1/log_actions/action', {
        fp: getQueryData().fp_id,
        action: 'main',
      });
    })
    .catch(function (error) {
      alert('데이터를 확인할 수 없습니다. 관리자에게 문의해주세요.');
      location.href = '/docs';
    });
}

function setListItems(item) {
  var listItemsHtml = item.map(function (item) {
    if (!item.exposure) return;
    return `<div class="item" onclick="onClickItems('${item.id.trim()}')" data-id="${item.id}"><div class="item-text">${item.title}</div><div class="item-btn-more">자세히 보기</div></div>`;
  });
  $('.list').append(listItemsHtml);
}

function onClickItems(id) {
  location.href = './detail?id=' + id;
}
