export type AuthRole = 'MASTER';
export type Status = 'active' | 'inactive';

export interface ResponseProfile {
  created: string;
  updated: string;
  username: string;
  role: AuthRole;
  status: Status;
  team: string | null;
  fp_id: string;
  menu: string;
  email: string;
  id: string;
}

export interface RegisterProfileData {
  username: string;
  fp_id: string;
  team: string | null;
  menu: string;
}

export interface UpdateUser {
  team: string;
  username: string;
}

export interface ResponsesLogin {
  id: string;
}

export interface UpdatePassword {
  email: string;
  oriPassword: string;
  password: string;
}
