//base
import React, { useState } from 'react';

//pages
import { UsersDataList } from './usersDataList';
import { UsersDataUpload } from './usersDataUpload';

// layouts
import { MainLayout } from 'layouts';

//style
import { MenuWrap } from './style';

//libraries
import { Menu, Layout } from 'antd';

const { Content } = Layout;

const USERS_DATA_LIST = 'users_data_list';
const USERS_DATA_UPLOAD = 'users_data_upload';

export const UsersDataPage: React.FC = () => {
  const [menu, setMenu] = useState(USERS_DATA_LIST);

  return (
    <MainLayout>
      <MenuWrap
        mode="horizontal"
        defaultSelectedKeys={[`${menu}`]}
        selectedKeys={[`${menu}`]}
        onClick={(clickItem) => {
          setMenu(clickItem.key);
        }}
      >
        <Menu.Item key={USERS_DATA_LIST}>업로드 내역</Menu.Item>
        <Menu.Item key={USERS_DATA_UPLOAD}>데이터 업로드</Menu.Item>
      </MenuWrap>
      <Content>{menu === USERS_DATA_LIST ? <UsersDataList /> : <UsersDataUpload />}</Content>
    </MainLayout>
  );
};
