//base
import React, { useState } from 'react';

//libraries
import { MainLayout } from 'layouts';
import { Layout, Menu } from 'antd';

//style
import { MenuWrap } from './style';
import { StatisticsList } from './StatisticsList';
import { StatisticsDetail } from './StatisticsDetail';
import { StatisticsOrigin } from './StatisticsOrigin';

const { Content } = Layout;

const STATISTICS_LIST = 'statistics_list';
const STATISTICS_DETAIL = 'statistics_detail';
const STATISTICS_ORIGIN = 'statistics_origin';

export const StatisticsPage: React.FC = () => {
  const [menu, setMenu] = useState(STATISTICS_LIST);

  return (
    <MainLayout>
      <MenuWrap
        mode="horizontal"
        defaultSelectedKeys={[`${menu}`]}
        selectedKeys={[`${menu}`]}
        onClick={(clickItem) => {
          setMenu(clickItem.key);
        }}
      >
        <Menu.Item key={STATISTICS_LIST}>통계 요약</Menu.Item>
        <Menu.Item key={STATISTICS_DETAIL}>상세 검색</Menu.Item>
        <Menu.Item key={STATISTICS_ORIGIN}>원본데이터</Menu.Item>
      </MenuWrap>
      <Content>
        {menu === STATISTICS_LIST ? (
          <StatisticsList />
        ) : menu === STATISTICS_DETAIL ? (
          <StatisticsDetail />
        ) : (
          <StatisticsOrigin />
        )}
      </Content>
    </MainLayout>
  );
};
