// base
import React from 'react';

// apis
import { authAPI } from 'apis/auth';

// services
import { STORAGE_SESSION_ACT } from 'services/storage';

// routes
import { ROUTE_ROOT } from 'routes/const';

// libraries
import { Button, Form, Input, message } from 'antd';
import { Store } from 'antd/lib/form/interface';
import { useNavigate } from 'react-router-dom';

// assets
import logo from 'assets/images/loginlogo.png';

// styles
import { LoginFormWrap } from './style';

export const LoginPage: React.FC = () => {
  const navigate = useNavigate();
  const onClickFinish = async (values: Store) => {
    try {
      const accessToken = await authAPI.login({
        email: values.email,
        password: values.password,
      });
      if (accessToken.id) {
        sessionStorage.setItem(STORAGE_SESSION_ACT, accessToken.id);
        navigate(ROUTE_ROOT);
      } else {
        throw new Error('로그인 실패');
      }
    } catch (error) {
      message.error(`${error}`);
    }
  };

  return (
    <LoginFormWrap>
      <div className="container">
        <img className="logo" src={logo} alt="logo" />
        <div className="login-form">
          <h1 className="title">로그인</h1>
          <Form onFinish={onClickFinish}>
            <Form.Item name="email" rules={[{ required: true, message: '아이디를 입력해주세요.' }]}>
              <Input placeholder="아이디를 입력해주세요." />
            </Form.Item>
            <Form.Item
              name="password"
              rules={[{ required: true, message: '비밀번호를 입력해주세요.' }]}
            >
              <Input placeholder="비밀번호를 입력해주세요." type="password" />
            </Form.Item>
            <Button type="primary" htmlType="submit" className="login-submit-btn">
              로그인
            </Button>
          </Form>
        </div>
      </div>
    </LoginFormWrap>
  );
};
