// base
import { HTMLAttributes } from 'react';

// components
import { Header } from 'components';
import { MainNav } from 'components/MainNav';

// libraries
import { Layout } from 'antd';

// style
import { StyledMainLayout } from './style';

const { Content, Sider } = Layout;

interface MainLayoutProps extends HTMLAttributes<HTMLDivElement> {}

export const MainLayout: React.FC = ({ children, ...props }: MainLayoutProps) => {
  return (
    <StyledMainLayout>
      <Header />
      <Layout>
        <Sider
          style={{
            height: '100vh',
            position: 'fixed',
            left: 0,
            top: 100,
            zIndex: 1,
          }}
        >
          <MainNav />
        </Sider>
        <Layout>
          <Content style={{ margin: '100px 16px 0px 200px' }}>
            <div className="site-layout-background">{children}</div>
          </Content>
        </Layout>
      </Layout>
    </StyledMainLayout>
  );
};
