// base
import React from 'react';

// styles
import { FileTxtWrap } from './style';

// libraries
import { Button, Upload } from 'antd';
import { InboxOutlined } from '@ant-design/icons';
import { UploadFile } from 'antd/lib/upload/interface';

interface DataUploaderProps {
  file: UploadFile<File> | undefined;
  setFile: (e: any) => void;
  onFinish: () => void;
  onReset: () => void;
}

export const DataUploader: React.FC<DataUploaderProps> = ({ file, setFile, onFinish, onReset }) => {
  return (
    <>
      <Upload.Dragger
        name="files"
        maxCount={1}
        multiple={false}
        beforeUpload={() => {
          return false;
        }}
        onChange={(info) => {
          setFile(info.file);
        }}
        accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
      >
        <p className="ant-upload-drag-icon">
          <InboxOutlined style={{ color: '#bdbdbd' }} />
        </p>
        <p className="ant-upload-text">파일을 끌어오거나 화면을 클릭해주세요</p>
        <p className="ant-upload-hint">*Excel 파일만 업로드 가능</p>
      </Upload.Dragger>

      <FileTxtWrap>
        <div className="line"></div>
        <div className="txt_box">
          파일 업로드
          <br />[ <span>{!file || file.status === 'removed' ? 0 : 1}</span> / 1 ]
        </div>
      </FileTxtWrap>
      <div>
        <Button type="primary" disabled={!file || file.status === 'removed'} onClick={onFinish}>
          등록
        </Button>
        <Button htmlType="reset" disabled={!file || file.status === 'removed'} onClick={onReset}>
          초기화
        </Button>
      </div>
    </>
  );
};
