import React from 'react';
import { CopyToClipboard } from 'react-copy-to-clipboard';

interface Props {
  text: string;
  onCopy(): void;
  children?: React.ReactNode;
}

export const CopyClipboard: React.FC<Props> = ({ text, onCopy, children }) => {
  return (
    <CopyToClipboard text={text} onCopy={onCopy}>
      {children}
    </CopyToClipboard>
  );
};
