import AxiosInstanceCreator from 'services/api';
import { LoopbackFilter, LoopbackWhere } from 'services/loopback';
import { MenuResult } from 'types/statistics';

export const logActionsInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_API_URL}/api/v1/log_actions`,
  withCredentials: true,
}).create();

export const logActionsAPI = {
  action: (filter: LoopbackFilter): Promise<MenuResult[]> => {
    return logActionsInstance.get('/', { params: { filter } }).then((res) => res.data);
  },
  count: (where: LoopbackWhere): Promise<{ count: number }> => {
    return logActionsInstance.get('/count', { params: { where } }).then((res) => res.data);
  },
};
