const moment = require("moment");
const crypto = require("crypto");
const CryptoJS = require("crypto-js");

const errorCode = (errCode) => {
  switch (errCode) {
    case 400:
      return {
        // 잘못된 요청
        errCode: "HW40000",
      };

    case 401:
      return {
        // 요청 실패
        errCode: "HW40001",
      };

    case 403:
      return {
        // 권한 필수
        errCode: "HW40003",
      };

    case 404:
      return {
        // Not Found
        errCode: "HW40004",
      };

    case 409:
      return {
        // conflict 데이터가 이미 존재
        errCode: "HW40009",
      };

    case 422:
      return {
        // 잘못된 요청
        errCode: "HW40022",
      };

    case 501:
      return {
        // 데이터 없음
        errCode: "HW50001",
      };

    default:
      return {
        // 서버 오류
        errCode: "HW50000",
      };
  }
};

const enumerateDaysBetweenDates = function (startDate, endDate) {
  const now = moment(startDate).clone(),
    dates = [];

  while (now.isSameOrBefore(endDate)) {
    dates.push(now.format("YYYY-MM-DD"));
    now.add(1, "days");
  }
  return dates;
};

function getUrlParams(url) {
  const params = {};

  url.replace(/[?&]+([^=&]+)=([^&]*)/gi, function (str, key, value) {
    params[key] = value;
  });

  return params;
}
function encrypt(text) {
  const cipher = crypto.createCipheriv(
    "aes-128-cbc",
    process.env.CRYPTO_KEY,
    process.env.CRYPTO_IV
  );

  let crypted = cipher.update(text, "utf8", "base64"); //base64 , hex
  crypted += cipher.final("base64");
  return crypted;
}

function decrypt(encryptdata) {
  const decipher = crypto.createDecipheriv(
    "aes-128-cbc",
    process.env.CRYPTO_KEY,
    process.env.CRYPTO_IV
  );
  decipher.setAutoPadding(false);
  let decoded = decipher.update(encryptdata, "base64", "utf8"); //base64 , hex
  decoded += decipher.final("utf8");
  return decoded;
}

function getRandomInt(min, max) {
  min = Math.ceil(min);
  max = Math.floor(max);
  return Math.floor(Math.random() * (max - min)) + min; //최댓값은 제외, 최솟값은 포함
}

module.exports = {
  errorCode,
  enumerateDaysBetweenDates,
  getUrlParams,
  encrypt,
  decrypt,
  getRandomInt,
};
