"use strict";

module.exports = function (LogUsersDataUpload) {
  LogUsersDataUpload.observe("before save", function (context, next) {
    const updatedDate = new Date();
    const _instance = context.instance;

    if (_instance) {
      _instance.created = updatedDate;
      _instance.updated = updatedDate;
    } else {
      if (!context.currentInstance) {
        return next();
      } else {
        context.data.updated = updatedDate;
      }
    }

    return next();
  });

  LogUsersDataUpload.beforeRemote(
    "find",
    function (context, modelInstance, next) {
      if (!context.args.filter) {
        context.args.filter = {};
      }

      let _where = {
        status: { neq: "inactive" },
      };

      if (context.args.filter.where) {
        if (context.args.filter.where.and) {
          context.args.filter.where.and.push(_where);
        } else {
          context.args.filter.where = {
            and: [context.args.filter.where, _where],
          };
        }
      } else {
        context.args.filter["where"] = _where;
      }

      return next();
    }
  );

  LogUsersDataUpload.beforeRemote(
    "count",
    function (context, modelInstance, next) {
      if (!context.args.where) {
        context.args.where = {};
      }

      let _where = {
        status: { neq: "inactive" },
      };

      if (context.args.where) {
        if (context.args.where.and) {
          context.args.where.and.push(_where);
        } else {
          context.args.where = {
            and: [context.args.where, _where],
          };
        }
      } else {
        context.args.where = _where;
      }

      return next();
    }
  );
};
