import { selector } from 'recoil';
import { ResponseProfile } from 'types/auth';
import { ResponseCdnurls } from 'types/cdnurls';
import { AuthState, CdnurlsState } from './recoil';

export const authProfileSelector = selector<ResponseProfile>({
  key: 'auth/ResponseProfile',
  get: ({ get }) => {
    return get(AuthState);
  },
  set: ({ set }, newProfile) => {
    set(AuthState, (prevState) => ({
      ...prevState,
      ...newProfile,
    }));
  },
});

export const cdnurlsSelector = selector<ResponseCdnurls[]>({
  key: 'cdnurls/ResponseCdnurls',
  get: ({ get }) => {
    return get(CdnurlsState);
  },
  set: ({ set }, newCdnurls) => {
    set(CdnurlsState, () => {
      return [...(newCdnurls as ResponseCdnurls[])];
    });
  },
});
