import { atom } from 'recoil';
import { ResponseProfile } from 'types/auth';
import { ResponseCdnurls } from 'types/cdnurls';

export const AuthState = atom<ResponseProfile>({
  key: 'auth/profile',
  default: {
    created: '',
    updated: '',
    username: '',
    role: 'MASTER',
    status: 'inactive',
    team: '',
    fp_id: '',
    menu: '[]',
    email: '',
    id: '',
  },
});

export const CdnurlsState = atom<ResponseCdnurls[]>({
  key: 'cdnurls/list',
  default: [
    {
      created: '',
      updated: '',
      imgFileUrl: '',
      ctntUrl: '',
      totalTime: '',
      fileName: '',
      id: '',
    },
  ],
});
