// base
import React from 'react';
import ReactDOM from 'react-dom';

// libraries
import styled from 'styled-components';
import { Spin } from 'antd';

const SpinContainer = styled.div`
  position: fixed;
  top: 0;
  left: 0;
  width: 100vw;
  height: 100vh;
  display: flex;
  justify-content: center;
  align-items: center;
  background: rgba(0, 0, 0, 0.4);
  z-index: 9999;
  .pageLoader_wrapper {
    text-align: center;
    &_text {
      margin: 15px 0px;
      font-size: 18px;
      color: #fff;
    }
  }
`;

export const PageLoader: React.FC = ({ children }) => {
  return ReactDOM.createPortal(
    <SpinContainer>
      <div className="pageLoader_wrapper">
        <div className="pageLoader_wrapper_text">{children}</div>
        <div>
          <Spin />
        </div>
      </div>
    </SpinContainer>,
    document.body
  );
};
