import AxiosInstanceCreator from 'services/api';
import { LoopbackFilter, LoopbackWhere } from 'services/loopback';
import { ResponseDocument, DocumentData } from 'types/document';

export const documentInstance = new AxiosInstanceCreator({
  baseURL: `${process.env.REACT_APP_API_URL}/api/v1/document`,
  withCredentials: true,
}).create();

export const documentAPI = {
  get: (filter: LoopbackFilter): Promise<ResponseDocument[]> => {
    return documentInstance.get('', { params: { filter } }).then((res) => res.data);
  },
  count: (where: LoopbackWhere): Promise<{ count: number }> => {
    return documentInstance.get('/count', { params: { where } }).then((res) => res.data);
  },
  update: (id: string, data: DocumentData): Promise<ResponseDocument[]> => {
    return documentInstance.patch(`/${id}`, data).then((res) => res.data);
  },
  uploadFile: (data: DocumentData, file: any): Promise<any> => {
    const formData = new FormData();
    formData.append('file', file);
    formData.append('data', JSON.stringify(data));
    return documentInstance.post('/uploadFile', formData).then((res) => res.data);
  },
};
