"use strict";

module.exports = function (Statistics) {
  const app = require("../../server/server");

  Statistics.beforeRemote("find", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {};

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  Statistics.beforeRemote("count", function (context, modelInstance, next) {
    if (!context.args.where) {
      context.args.where = {};
    }

    let _where = {};

    if (context.args.where) {
      if (context.args.where.and) {
        context.args.where.and.push(_where);
      } else {
        context.args.where = {
          and: [context.args.where, _where],
        };
      }
    } else {
      context.args.where = _where;
    }

    return next();
  });

  Statistics.afterRemote("find", function (context, result, next) {
    const mapData = {};

    result.forEach((r) => {
      if (!mapData[r.employee_id]) {
        mapData[r.employee_id] = {
          video: 0,
          document: 0,
          main: 0,
        };
      }

      mapData[r.employee_id] = {
        created: r.created,
        updated: r.updated,
        id: r.id,
        area: r.area,
        branch: r.branch,
        employee_id: r.employee_id,
        l2_name: r.l2_name,
        name: r.name,
        region: r.region,
        type: r.type,
        video: mapData[r.employee_id].video + r.video,
        document: mapData[r.employee_id].document + r.document,
        main: mapData[r.employee_id].main + r.main,
      };
    });

    context.result = Object.values(mapData);

    return next();
  });

  Statistics.beforeRemote("action", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {};

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  Statistics.action = (filter, group, req, cb) => {
    Statistics.find(filter)
      .then((res) => {
        const result = {};

        res.forEach((statistics) => {
          if (!statistics.type) {
            return;
          }

          if (!result[`${statistics.type}: ${statistics[group]}`]) {
            result[`${statistics.type}: ${statistics[group]}`] = {
              video: 0,
              document: 0,
              main: 0,
            };
          }

          result[`${statistics.type}: ${statistics[group]}`] = {
            created: statistics.created,
            updated: statistics.updated,
            id: statistics.id,
            area: statistics.area,
            branch: statistics.branch,
            l2_name: statistics.l2_name,
            region: statistics.region,
            type: statistics.type,
            title: statistics.type,
            video:
              result[`${statistics.type}: ${statistics[group]}`].video +
              statistics.video,
            document:
              result[`${statistics.type}: ${statistics[group]}`].document +
              statistics.document,
            main:
              result[`${statistics.type}: ${statistics[group]}`].main +
              statistics.main,
          };
        });
        cb(null, Object.values(result));
      })
      .catch((err) => {
        cb(err);
      });
  };

  Statistics.select = (title, cb) => {
    const usersData = app.models.usersData;
    usersData
      .find({
        where: {
          title: title,
        },
      })
      .then((res) => {
        const result = [
          ...new Set(
            res.map((item) => {
              return {
                title: item.title,
                l2_name: item.l2_name,
                region: item.region,
                area: item.area,
                branch: item.branch,
              };
            })
          ),
        ];
        cb(null, result);
      })
      .catch((err) => {
        throw err;
      });
  };
};
