"use strict";

module.exports = function (LogAction) {
  const app = require("../../server/server");
  const moment = require("moment");

  LogAction.observe("before save", function (context, next) {
    const updatedDate = new Date();
    const _instance = context.instance;

    if (_instance) {
      _instance.created = updatedDate;
      _instance.updated = updatedDate;
    } else {
      if (!context.currentInstance) {
        return next();
      } else {
        context.data.updated = updatedDate;
      }
    }

    return next();
  });

  LogAction.beforeRemote("find", function (context, modelInstance, next) {
    if (!context.args.filter) {
      context.args.filter = {};
    }

    let _where = {};

    if (context.args.filter.where) {
      if (context.args.filter.where.and) {
        context.args.filter.where.and.push(_where);
      } else {
        context.args.filter.where = {
          and: [context.args.filter.where, _where],
        };
      }
    } else {
      context.args.filter["where"] = _where;
    }

    return next();
  });

  LogAction.beforeRemote("count", function (context, modelInstance, next) {
    if (!context.args.where) {
      context.args.where = {};
    }

    let _where = {};

    if (context.args.where) {
      if (context.args.where.and) {
        context.args.where.and.push(_where);
      } else {
        context.args.where = {
          and: [context.args.where, _where],
        };
      }
    } else {
      context.args.where = _where;
    }

    return next();
  });

  LogAction.action = (fp, action, cb) => {
    const UsersData = app.models.usersData;
    UsersData.findOne({
      where: {
        employee_id: fp,
      },
    })
      .then((res) => {
        if (res) {
          const _result = {
            title: res.title,
            l2_name: res.l2_name,
            region: res.region,
            area: res.area,
            branch: res.branch,
            employee_id: res.employee_id,
            name: res.name,
            action: action,
          };
          return LogAction.create(_result);
        }

        return "OK";
      })
      .then((res) => {
        cb(null, res);
      })
      .catch((err) => {
        cb(err);
      });
  };
};
